<?php
/**
 * The header for our theme
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package hostiko
 */
$hostiko_redux_option = get_option('opt_theme_options');
$hostiko_header = $hostiko_redux_option['headerstyle'];
if(isset($_REQUEST['header'])){
	$hostiko_header = $_REQUEST['header'];
}
if ( empty( $hostiko_header ) ) {
	$hostiko_header = 'default';
}
?>
<!doctype html>
<html <?php language_attributes(); ?>>
<head>

<!-- Matomo
<script type="text/javascript">
  var _paq = window._paq = window._paq || [];
  /* tracker methods like "setCustomDimension" should be called before "trackPageView" */
  _paq.push(['trackPageView']);
  _paq.push(['enableLinkTracking']);
  (function() {
    var u="//schnetz.ml/";
    _paq.push(['setTrackerUrl', u+'matomo.php']);
    _paq.push(['setSiteId', '1']);
    var d=document, g=d.createElement('script'), s=d.getElementsByTagName('script')[0];
    g.type='text/javascript'; g.async=true; g.src=u+'matomo.js'; s.parentNode.insertBefore(g,s);
  })();
</script>
End Matomo Code -->


	<meta charset="<?php bloginfo( 'charset' ); ?>">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<link rel="profile" href="https://gmpg.org/xfn/11">
	<?php
    wp_head();?>
<?php
if(isset($hostiko_redux_option['constructionPage'])&&$hostiko_redux_option['constructionPage']&&!is_user_logged_in()){
	?>
	 <link rel="stylesheet" href="<?php echo  get_template_directory_uri() ;?>/layouts/underconstruction/css/bootstrap.css">
  <link rel="stylesheet" href="<?php echo  get_template_directory_uri() ;?>/layouts/underconstruction/css/font-awesome.min.css">
  <link rel="stylesheet" href="<?php echo  get_template_directory_uri() ;?>/layouts/underconstruction/css/animate.css">
  <!-- Theme CSS -->
  <link rel="stylesheet" href="<?php echo  get_template_directory_uri() ;?>/layouts/underconstruction/css/style.css">
  </head>
  <body <?php body_class(); ?> >
	<?php
}
else{?>
</head>
<?php
/**    CSS include of header as per Redux **/
hostikoLayoutHeader($hostiko_header);
hostiko_template_css();
?>
<body <?php body_class(); ?>>
    <?php if(($hostiko_redux_option['show-preloader'] != '0') &&
            !empty($hostiko_redux_option['show-preloader'])
    )
            {
     ?>
<div id="preloader">
    <div id="status">&nbsp;</div>
</div>
                <?php
            }  ?>
    <!--- your page content goes here -->
<div id="page" class="site">
	<a class="skip-link screen-reader-text" href="#content"><?php esc_html_e( 'Skip to content', 'hostiko' ); ?></a>
	<?php
	get_template_part('layouts/header/header-'. $hostiko_header .'/header-'. $hostiko_header, get_post_format());
		?>
	<div id="content" class="site-content container">
<?php }?>