/**
 * footer-reveal.js
 * 
 * Licensed under the MIT license.
 * http://www.opensource.org/licenses/mit-license.php
 * 
 * Copyright 2014 Iain Andrew
 * https://github.com/IainAndrew
 */

(function($) {

  $.fn.footerReveal = function(options) {

    var $this = $(this),
        $prev = $this.prev(),
        $win = $(window),

        defaults = $.extend ({
          shadow : true,
          shadowOpacity: 0.8,
          zIndex : -100
        }, options ),

        settings = $.extend(true, {}, defaults, options);

    if ($this.outerHeight() <= $win.outerHeight() && $this.offset().top >= $win.outerHeight()) {
      $this.css({
        'z-index' : defaults.zIndex,
        position : 'fixed',
        bottom : 0
      });

      if (defaults.shadow) {
        $prev.css ({
          '-moz-box-shadow' : '0 20px 30px -20px rgba(0,0,0,' + defaults.shadowOpacity + ')',
          '-webkit-box-shadow' : '0 20px 30px -20px rgba(0,0,0,' + defaults.shadowOpacity +')',
          'box-shadow' : '0 20px 30px -20px rgba(0,0,0,' + defaults.shadowOpacity + ')'
        });
      }

      $win.on('load resize footerRevealResize', function() {
        $this.css({
          'width' : $prev.outerWidth()
        });
        $prev.css({
          'margin-bottom' : $this.outerHeight()
        });
      });
    }

    return this;

  };

}) (jQuery);

(function($) {
    'use strict';
    
    $(document).ready(function() {
        
        if($('.bb-footer-reveal').length > 0) {
            $('.bb-footer-reveal').footerReveal();        
            $(window).trigger('resize');
        }

        // Search
        $('.bbfb-btn-search').on('click', function(){
          var $target = $($(this).attr('href'));
          $target.addClass('bbfb-visible');
          return false;
        });
        $('.bbfb-search-close').on('click', function(){
          var $self = $( this );
          var $target = $self.closest('.bbfb-search-box');
          $target.removeClass('bbfb-visible');
          return false;
        });
        
    });

}(window.jQuery));
