<?php

namespace MGModule\vultr\helpers;

use WHMCS\Database\Capsule as DB;

class ProductsHelper
{


	public static function configurableOptions($productID)
	{
		$vultrAPI = ApiHelper::getAPI();
		if ($vultrAPI->checkConnection())
		{
			return self::prepareConfigurableOptions($vultrAPI, $productID);
		}
		else
		{
			return array('status' => FALSE, 'message' => 'connection problem');
		}
	}

	private static function prepareConfigurableOptions($vultrAPI, $productID)
	{
		$checkIsset = DB::table('tblproductconfiglinks')->where('pid', $productID)->get();

		if ($checkIsset)
		{
			return array('status' => false, 'message' => 'Product configurable options already exist!');
		}


		$productConfigGroupID = DB::table('tblproductconfiggroups')->insertGetId(array('name' => 'Vultr', 'description' => 'Autogenerated Vultr #' . $productID . ' Configurable Options'));
		DB::table('tblproductconfiglinks')->insert(array('gid' => $productConfigGroupID, 'pid' => $productID));

		$autoBackupID = DB::table('tblproductconfigoptions')->insertGetId(array('gid' => $productConfigGroupID, 'optionname' => 'auto_backups|Auto backups', 'optiontype' => '3'));
		$autoBackupSubOptionID = DB::table('tblproductconfigoptionssub')->insertGetId(array('configid' => $autoBackupID, 'optionname' => 'Yes'));
		//Add pricing for autobackups configoptions
		self::insertSubOptionsPricing($autoBackupSubOptionID);


		$snapshotID = DB::table('tblproductconfigoptions')->insertGetId(array('gid' => $productConfigGroupID, 'optionname' => 'snapshots|Snapshots limit', 'optiontype' => '4', 'qtyminimum' => '0', 'qtymaximum' => '10'));
		$snapshotSubOptionID = DB::table('tblproductconfigoptionssub')->insertGetId(array('configid' => $snapshotID, 'optionname' => '1'));
		//Add pricing for snapshots configoption
		self::insertSubOptionsPricing($snapshotSubOptionID);

		$osID = DB::table('tblproductconfigoptions')->insertGetId(array('gid' => $productConfigGroupID, 'optionname' => 'os_type|OS Type', 'optiontype' => '1'));

		foreach ($vultrAPI->os_list() as $value)
		{
			if ($value['name'] == "Backup")
			{
				continue;
			}
			if ($value['name'] == "Custom")
			{
				$value['name'] = "ISO";
			}
			$osSubOptionID = DB::table('tblproductconfigoptionssub')->insertGetId(array('configid' => $osID, 'optionname' => $value['OSID'] . '|' . $value['name']));

			//Add pricing for operating system configoption
			self::insertSubOptionsPricing($osSubOptionID);

		}


		$appID = DB::table('tblproductconfigoptions')->insertGetId(array('gid' => $productConfigGroupID, 'optionname' => 'application|Application', 'optiontype' => '1'));
		$noneOptionId = DB::table('tblproductconfigoptionssub')->insertGetId(array('configid' => $appID, 'optionname' => '0|None'));
		self::insertSubOptionsPricing($noneOptionId);
		foreach ($vultrAPI->app_list() as $value)
		{
			$appSubOptionID = DB::table('tblproductconfigoptionssub')->insertGetId(array('configid' => $appID, 'optionname' => $value['APPID'] . '|' . $value['deploy_name']));
			//Add pricing for application configoption
			self::insertSubOptionsPricing($appSubOptionID);

		}

		return array('status' => true, 'reload' => true, 'message' => 'success');
	}

	private static function insertSubOptionsPricing($subOptionId)
	{
		//Getting all available currencies
		$currencies = DB::table('tblcurrencies')->select("tblcurrencies.id")->get();
		foreach ($currencies as $value)
		{
			DB::table('tblpricing')->insert(array(
				'type' => "configoptions",
				'currency' => $value->id,
				'relid' => $subOptionId
			));
		}
	}

	public static function getProductConfigOptions($productID, $field = 'all', $default = '')
	{
		$result = DB::table('tblproducts')->where('id', $productID)->first();
		if ($field == 'all')
		{
			return $result;
		}
		else
		{
			if (isset($result->{$field}))
			{
				return $result->{$field};
			}
			else
			{
				return $default;
			}
		}
	}

	public static function customFields($productID)
	{
		$result = DB::table('tblcustomfields')->where('fieldname', 'subid|Virtual machine ID')->where('type', 'product')->where('relid', $productID)->select('id')->get();
		if (!$result)
		{
			DB::table('tblcustomfields')->insert(array('type' => 'product', 'relid' => $productID, 'fieldname' => 'subid|Virtual machine ID', 'fieldtype' => 'text', 'adminonly' => 'on'));
			return array('status' => true, 'reload' => true, 'message' => 'success');
		}
		return array('status' => true, 'message' => 'success');
	}

}
